// DialogMoveHomeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "8949G1VC.h"
#include "DialogMoveHomeDlg.h"

#include "ADT8949.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogMoveHomeDlg dialog

bool g_bStop = false;

CDialogMoveHomeDlg::CDialogMoveHomeDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogMoveHomeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogMoveHomeDlg)
	m_home_axis = 1;
	m_home_gear = 1000.0f;
	m_home_offset = 0.0f;
	m_home_startv = 1.0f;
	m_home_add = 500.0f;
	m_home_speed_k = 10.0f;
	m_home_speed_L = 0.8f;
	m_home_speed_L_Z = 0.5f;
	m_home_dir = 0;
	m_home_BackRange = 2.0f;
	m_DA_ID = 0;
	m_DA_num = 0.0f;
	m_stop0 = 0;
	m_limit = 0;
	m_stop1 = -1;
	//}}AFX_DATA_INIT
}


void CDialogMoveHomeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogMoveHomeDlg)
	DDX_Text(pDX, IDC_EDIT1, m_home_axis);
	DDX_Text(pDX, IDC_EDIT6, m_home_gear);
	DDX_Text(pDX, IDC_EDIT8, m_home_offset);
	DDX_Text(pDX, IDC_EDIT2, m_home_startv);
	DDX_Text(pDX, IDC_EDIT7, m_home_add);
	DDX_Text(pDX, IDC_EDIT9, m_home_speed_k);
	DDX_Text(pDX, IDC_EDIT10, m_home_speed_L);
	DDX_Text(pDX, IDC_EDIT11, m_home_speed_L_Z);
	DDX_Radio(pDX, IDC_RADIO1, m_home_dir);
	DDX_Text(pDX, IDC_EDIT12, m_home_BackRange);
	DDX_Text(pDX, IDC_EDIT13, m_DA_ID);
	DDX_Text(pDX, IDC_EDIT14, m_DA_num);
	DDX_Text(pDX, IDC_EDIT15, m_stop0);
	DDX_Text(pDX, IDC_EDIT16, m_limit);
	DDX_Text(pDX, IDC_EDIT17, m_stop1);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogMoveHomeDlg, CDialog)
	//{{AFX_MSG_MAP(CDialogMoveHomeDlg)
	ON_BN_CLICKED(IDC_BUTTON_MOVEHOME1, OnButtonMovehome1)
	ON_BN_CLICKED(IDC_BUTTON_MOVEHOME2, OnButtonMovehome2)
	ON_BN_CLICKED(IDC_BUTTON_MOVEHOME3, OnButtonSetDA)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogMoveHomeDlg message handlers

void CDialogMoveHomeDlg::OnButtonMovehome1() 
{
	// TODO: Add your control notification handler code here
	
	
	UpdateData();
	
	
	CString str;
	int retnX = -1;
	int step=1;
	int sta=0;	
	int err=0;
	


	err=adt8949_SetHomeMode_Ex(g_cardID,m_home_axis,m_home_dir,m_stop0,m_limit,m_stop1,m_home_BackRange,20,m_home_offset);	
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeMode_Ex Parameter setting exception");
	}

	err=adt8949_SetHomeSpeed_Ex(g_cardID,m_home_axis,m_home_startv,m_home_speed_k,m_home_speed_L,m_home_add,m_home_speed_L_Z);	
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeSpeed_Ex Parameter setting exception");
	}
	err=adt8949_HomeProcess_Ex(g_cardID,m_home_axis,m_home_gear);
	if (err!=0)
	{
		MessageBox("adt8949_HomeProcess_Ex Parameter setting exception");
	}
	str.Format("return zero status%ld",retnX);
	GetDlgItem(IDC_HOME_STATUS)->SetWindowText(str);
	
	while(true)
	{
		DoEvent();
		Sleep(1);
		retnX = adt8949_GetHomeStatus_Ex(g_cardID,m_home_axis);
		str.Format("return zero status%ld",retnX);
		GetDlgItem(IDC_HOME_STATUS)->SetWindowText(str);
		if(retnX>20 || retnX<0 )
		{
			MessageBox("return zero failed");
			return;
			
		}
		else if(retnX==0)
		{
			MessageBox("return zero successed");
			return;
			
		}
		else
		{
			//ѯ״̬
		}	
	}		
	


}

void CDialogMoveHomeDlg::OnButtonMovehome2() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData();
	
	
	CString str;
	int retnX = -1;
	int retnY = -1;
	int step=1;
	int sta=0;	
	int err=0;
	
	BOOL    FailFlag[] = {TRUE,TRUE,TRUE,TRUE};	
	BOOL    SuccessFlag[] = {TRUE,TRUE,TRUE,TRUE};
	
	
	
	err=adt8949_SetHomeMode_Ex(g_cardID,1,m_home_dir,m_stop0,m_limit,m_stop1,m_home_BackRange,20,m_home_offset);
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeMode_Ex Parameter setting exception");
	}

	err=adt8949_SetHomeSpeed_Ex(g_cardID,1,m_home_startv,m_home_speed_k,m_home_speed_L,m_home_add,m_home_speed_L_Z);	
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeSpeed_Ex Parameter setting exception");
	}

	err=adt8949_HomeProcess_Ex(g_cardID,1,m_home_gear);
	if (err!=0)
	{
		MessageBox("adt8949_HomeProcess_Ex Parameter setting exception");
	}

	FailFlag[0] = FALSE;
	SuccessFlag[0] = FALSE;
	
	
	err=adt8949_SetHomeMode_Ex(g_cardID,2,m_home_dir,m_stop0,m_limit,m_stop1,m_home_BackRange,20,m_home_offset);	
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeMode_Ex Parameter setting exception");
	}

	err=adt8949_SetHomeSpeed_Ex(g_cardID,2,m_home_startv,m_home_speed_k,m_home_speed_L,m_home_add,m_home_speed_L_Z);
	if (err!=0)
	{
		MessageBox("adt8949_SetHomeSpeed_Ex Parameter setting exception");
	}

	err=adt8949_HomeProcess_Ex(g_cardID,2,m_home_gear);
	if (err!=0)
	{
		MessageBox("adt8949_HomeProcess_Ex Parameter setting exception");
	}

	FailFlag[1] = FALSE;
	SuccessFlag[1] = FALSE;
	
	
	
	while(true)
	{
		DoEvent();
		Sleep(1);
		retnX = adt8949_GetHomeStatus_Ex(g_cardID,1);
		
		str.Format("%ld",retnX);
		GetDlgItem(IDC_STATIC_XX)->SetWindowText(str);
		
		if(retnX>20 || retnX<0 )
		{
			GetDlgItem(IDC_STATIC_X)->SetWindowText("X axis return zero failed");	
			FailFlag[0] = TRUE;//ȫʧܾͷ
			
		}
		else if(retnX==0)
		{
			GetDlgItem(IDC_STATIC_X)->SetWindowText("X axis return zero successed");	
			SuccessFlag[0] = TRUE;
			
		}
		
		
		
		retnY = adt8949_GetHomeStatus_Ex(g_cardID,2);
		
		str.Format("%ld",retnY);
		GetDlgItem(IDC_STATIC_YY)->SetWindowText(str);
		if(retnY>20 || retnY<0 )
		{
			GetDlgItem(IDC_STATIC_Y)->SetWindowText("Y axis return zero failed");	
			FailFlag[1] = TRUE;//ȫʧܾͷ
			
		}
		else if(retnY==0)
		{
			GetDlgItem(IDC_STATIC_Y)->SetWindowText("Y axis return zero successed");	
			SuccessFlag[1] = TRUE;
			
		}
		
		
		if (SuccessFlag[0] && SuccessFlag[1] && SuccessFlag[2] && SuccessFlag[3])
		{
			MessageBox("return zero successed");
			return;
		}
		if (FailFlag[0] && FailFlag[1] && FailFlag[2] && FailFlag[3])
		{
			return;
		}
		
		
		
	}		
	



}

void CDialogMoveHomeDlg::OnButtonSetDA() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	adt8949_set_daout(g_cardID,m_DA_ID,m_DA_num);
}
